"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WATCH_STATUS = exports.WATCH_EXAMPLES = exports.WATCH_ACTION_STATUS = exports.ROUTE_PATH = exports.PERMISSIONS_FOR_ACCESS = exports.NO_MULTITENANCY_TENANT = exports.MAX_DOC_COUNT_SEARCH = exports.INDEX = exports.ES_SCROLL_SETTINGS = exports.DEFAULT_DATEFIELD_RANGE_QUERY_LT = exports.DEFAULT_DATEFIELD_RANGE_QUERY_GTE = exports.DEFAULT_DATEFIELD = exports.BASE_URI = exports.APP_NAME = exports.APP_DESCRIPTION = void 0;
/* eslint-disable @kbn/eslint/require-license-header */
const APP_NAME = exports.APP_NAME = 'searchguard-signals';
const APP_DESCRIPTION = exports.APP_DESCRIPTION = 'Search Guard Signals';
const INDEX = exports.INDEX = {
  ALERTS: '.signals_log_*',
  ALERT_DOC_TYPE: '_doc'
};
const BASE_URI = exports.BASE_URI = `/api/${APP_NAME}`;
const ROUTE_PATH = exports.ROUTE_PATH = {
  WATCH: `${BASE_URI}/watch`,
  WATCHES: `${BASE_URI}/watches`,
  ACCOUNT: `${BASE_URI}/account`,
  ACCOUNTS: `${BASE_URI}/accounts`,
  WATCH_EXECUTE: `${BASE_URI}/watch/_execute`,
  WATCH_EXECUTE_GRAPH: `${BASE_URI}/watch/_execute_graph`,
  ALERT: `${BASE_URI}/alert`,
  ALERTS: `${BASE_URI}/alerts`,
  SEARCH: `${BASE_URI}/_search`,
  MAPPINGS: `${BASE_URI}/_mappings`,
  INDICES: `${BASE_URI}/_indices`,
  ALIASES: `${BASE_URI}/_aliases`,
  SEARCHGUARD: {
    SIGNALS_HAS_PERMISSIONS: `${BASE_URI}/searchguard/signals_has_permissions`
  }
};
const MAX_DOC_COUNT_SEARCH = exports.MAX_DOC_COUNT_SEARCH = 800;
const DEFAULT_DATEFIELD = exports.DEFAULT_DATEFIELD = 'execution_end';
const DEFAULT_DATEFIELD_RANGE_QUERY_GTE = exports.DEFAULT_DATEFIELD_RANGE_QUERY_GTE = 'now-30m';
const DEFAULT_DATEFIELD_RANGE_QUERY_LT = exports.DEFAULT_DATEFIELD_RANGE_QUERY_LT = 'now';
const ES_SCROLL_SETTINGS = exports.ES_SCROLL_SETTINGS = {
  KEEPALIVE: '25s',
  PAGE_SIZE: 10
};
const WATCH_EXAMPLES = exports.WATCH_EXAMPLES = {
  AVG_TICKET_PRICE: 'avg_ticket_price',
  BAD_WEATHER: 'bad_weather',
  CHANGE_IN_MEMORY: 'change_in_memory',
  MAX_MEMORY: 'max_memory',
  MEMORY_USAGE: 'memory_usage',
  MIN_PRODUCT_PRICE: 'min_product_price'
};
const NO_MULTITENANCY_TENANT = exports.NO_MULTITENANCY_TENANT = '_main';
const WATCH_STATUS = exports.WATCH_STATUS = {
  EXECUTION_FAILED: 'EXECUTION_FAILED',
  ACTION_EXECUTED: 'ACTION_EXECUTED',
  NO_ACTION: 'NO_ACTION',
  ACKED: 'ACKED'
};
const WATCH_ACTION_STATUS = exports.WATCH_ACTION_STATUS = {
  ACTION_FAILED: 'ACTION_FAILED',
  ACTION_THROTTLED: 'ACTION_THROTTLED',
  ACTION_EXECUTED: 'ACTION_EXECUTED',
  ACKED: 'ACKED'
};
const PERMISSIONS_FOR_ACCESS = exports.PERMISSIONS_FOR_ACCESS = ['cluster:admin:searchguard:tenant:signals:watch/get'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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